---
title: Validation checks · Cloudflare Web Application Firewall (WAF) docs
description: Cloudflare performs a validation check for every request. The
  Validation component executes prior to all other security features like custom
  rules or Managed Rules. The validation check blocks malformed requests like
  Shellshock attacks and requests with certain attack patterns in their HTTP
  headers before any allowlist logic occurs.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/validation-checks/
  md: https://developers.cloudflare.com/waf/tools/validation-checks/index.md
---

Cloudflare performs a validation check for every request. The Validation component executes prior to all other security features like custom rules or Managed Rules. The validation check blocks malformed requests like Shellshock attacks and requests with certain attack patterns in their HTTP headers before any allowlist logic occurs.

Note

Currently, you cannot disable validation checks. They run early in Cloudflare's infrastructure before the configuration for domains has been loaded.

## Event logs for validation checks

Actions performed by the Validation component appear in [Sampled logs](https://developers.cloudflare.com/waf/analytics/security-events/#sampled-logs) in Security Events, associated with the `Validation` service and without a rule ID. Event logs downloaded from the API show source as `Validation` and action as `drop` when this behavior occurs.

The following example shows a request blocked by the Validation component due to a malformed `User-Agent` HTTP request header:

![Sampled logs displaying an example of a validation check event](https://developers.cloudflare.com/_astro/validation-service.CC6rqWo__Z1aSykk.webp)

In the downloaded JSON file for the event, the `ruleId` value indicates the detected issue — in this case, it was a Shellshock attack.

```json
{
  "action": "drop",
  "ruleId": "sanity-shellshock",
  "source": "sanitycheck",
  "userAgent": "() { :;}; printf \\\\\"detection[%s]string\\\\\" \\\\\"TjcLLwVzBtLzvbN\\\\"
  //...
}
```
