---
title: Nouns and pronouns · Cloudflare Style Guide
description: Refer to the customer in the second person. Where this is not
  possible, use gender neutral pronouns. Do not use “one” as a pronoun.
lastUpdated: 2025-03-20T21:27:24.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/nouns-and-pronouns/
  md: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/nouns-and-pronouns/index.md
---

Refer to the customer in the second person. Where this is not possible, use gender neutral pronouns. Do not use “one” as a pronoun.

Make sure it is clear who or what pronouns are in reference to. Pronouns act as signposts to the subject of the sentence and should not be used so much that the subject is no longer clear.

## First person

Substitute "we" or "I" with "Cloudflare" if you need to represent Cloudflare. You do not need to use "we" constantly. However, use it when it is the best choice grammatically.

| ✅ | ❌ |
| - | - |
| Cloudflare recommends you submit image or plain text files. | We recommend closing your files before you restart your computer. |

## Second person

When you give instructions, use the polite command form with the second person "you" or in special cases "they" or "it".

## Referring to people

Use "you" instead of "the user" when the audience is the user of a Cloudflare product.

As a last resort, use passive voice if the subject is obvious or irrelevant.
